**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for RDD  Density cahrt figure 10 ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************
*** Code strcuture
*01. Make  BIT income varaibles
*02 Anlayisis

************* 01. Bring data **********					  

use "$data\rdd_$ids.dta", clear

** set up output location
	putexcel set "$savefile\Manip tests_`ids'.xlsx",  modify
	
	************* 02. Analysis **********					  

****** GFC policy
** Sales density regressions test
rddensity sales2_c  if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 3 & year==2010

matrix m = J(8,1,.)
matrix m[1,1] = e(pval_q)
matrix m[2,1] = e(se_q)
matrix m[3,1] = e(N_l)
matrix m[4,1] = e(N_r)
matrix m[5,1] = e(n_l)
matrix m[6,1] = e(n_r)
matrix m[7,1] = e(f_ql)
matrix m[8,1] = e(f_qr)

mat rownames m = "p-value" "se" "No obs left" "No obs right" "Eff obs left" "Eff obs right" "Eff desne left" "Eff Dense right"

	putexcel A1="Q1 2010"
	putexcel A2=matrix(m), rownames 



 *Chart of density density
 preserve
 keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2 & sales2_c>-500000 & sales2_c<500000 & quarter== 3 & year==2010  // keep only relevant period and firms
local bin = 25000
g sales2_round = `bin'*floor(income_l2/`bin')  // assign to bins
collapse(count) firms=firmid, by(sales2_round) // collapse
export excel using "$savefile\GFC_sales_desnity_chart.xlsx", sheetmodify firstrow(variables)
restore

****** 2012 policy
** Sales density
eststo clear
 rddensity sales2_c  if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 1 & year==2013 
 

matrix m = J(8,1,.)
matrix m[1,1] = e(pval_q)
matrix m[2,1] = e(se_q)
matrix m[3,1] = e(N_l)
matrix m[4,1] = e(N_r)
matrix m[5,1] = e(n_l)
matrix m[6,1] = e(n_r)
matrix m[7,1] = e(f_ql)
matrix m[8,1] = e(f_qr)

mat rownames m = "p-value" "se" "No obs left" "No obs right" "Eff obs left" "Eff obs right" "Eff desne left" "Eff Dense right"

	putexcel D1="Q1 2013"
	putexcel D2=matrix(m), rownames 
 
 

 *Chart density
 preserve
 keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2 & sales2_c>-500000 & sales2_c<500000 & quarter== 1 & year==2013 
local bin = 25000
g sales2_round = `bin'*floor(income_l2/`bin') 
collapse(count) firms=firmid, by(sales2_round)
export excel using "$savefile\2012_sales_desnity_chart.xlsx", sheetmodify firstrow(variables)
restore



****** 2015 policy
** Sales density
eststo clear
 rddensity sales2_c  if income_l<$ubl2 & income_l>$lb2 & income> $lb2 & quarter== 1 & year==2016 


matrix m = J(8,1,.)
matrix m[1,1] = e(pval_q)
matrix m[2,1] = e(se_q)
matrix m[3,1] = e(N_l)
matrix m[4,1] = e(N_r)
matrix m[5,1] = e(n_l)
matrix m[6,1] = e(n_r)
matrix m[7,1] = e(f_ql)
matrix m[8,1] = e(f_qr)


mat rownames m = "p-value" "se" "No obs left" "No obs right" "Eff obs left" "Eff obs right" "Eff desne left" "Eff Dense right"

	putexcel G1="Q1 2016"
	putexcel G2=matrix(m), rownames 

 *Chart density
 preserve
 keep if  income_l<$ubl2 & income_l>$lb2 & income> $lb2 & sales2_c>-500000 & sales2_c<500000 & quarter== 1 & year==2016 
local bin = 25000
g sales2_round = `bin'*floor(income_l2/`bin') 
collapse(count) firms=firmid, by(sales2_round)
export excel using "$savefile\2015_sales_desnity_chart.xlsx", sheetmodify firstrow(variables)
restore

****** 2016 10m policy
** Sales density
eststo clear
 rddensity sales10_c  if income_l<$ubl10 & income_l>$lb10 & income> $lb10 & quarter== 1 & year==2017 

 

matrix m = J(8,1,.)
matrix m[1,1] = e(pval_q)
matrix m[2,1] = e(se_q)
matrix m[3,1] = e(N_l)
matrix m[4,1] = e(N_r)
matrix m[5,1] = e(n_l)
matrix m[6,1] = e(n_r)
matrix m[7,1] = e(f_ql)
matrix m[8,1] = e(f_qr)

mat rownames m = "p-value" "se" "No obs left" "No obs right" "Eff obs left" "Eff obs right" "Eff desne left" "Eff Dense right"

	
	putexcel J1="Q1 2017"
	putexcel J2=matrix(m), rownames 

 *Chart density
 preserve
 keep if  income_l<$ubl10 & income_l>$lb10 & income> $lb10 & sales10_c>-1000000 & sales10_c<1000000 & quarter== 1 & year==2017 
local bin = 50000
g sales2_round = `bin'*floor(income_l2/`bin') 
collapse(count) firms=firmid, by(sales2_round)
export excel using "$savefile\2016_sales_desnity_chart.xlsx", sheetmodify firstrow(variables)
restore
